%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 9.4
% File: cond_mode.m
% Coded by: Dawit Zerom
%
% Computing conditional MODE forecasts. 
%
% Reference:
% De Gooijer, J.G. and Zerom, D. (2000).
%    Kernel based multi-step-ahead prediction of the U.S. short-term 
%    interest rate. Journal of Forecasting, 19(4), 335-353.
%    DOI: 10.1002/1099-131x(200007)19:4\%3C335::aid-for777\%3E3.3.co;2-v
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load    = waiting.dat;
datan   = waiting;
[nr,nc] = size(datan);
data1   = datan; 
k       = 1;    % Maximum Markov order
mx      = 10;   % Maximum forecast horizon   
x1      = data1(k:nr);
data    = x1;
z       = data;
n2      = 289;  % Start data set Geyser-waiting time
n3      = 289;     
df      = n3-n2+1; 
n       = n2;
while n<=n3;
   m = 1;
   while m <= mx;
       n0   = n-m;
       y    = z(m+1:n,1);
       x0   = z(1:n0);
       sd   = std(data1(1:n));
       hop  = (sd)*((n)^(-1/(k+4)));
       a    = min(y)-3*hop;
       b    = max(y)+3*hop;
       step = (b-a)/256;
       sum1 = 0;
       sum2 = 0;
       i = 1;
       while i <= n0;
          vect1 = (z(n)-x0(i))/hop;
          xx    = vect1*vect1';
          vect2 = (a-y(i))/hop;
          xx2   = vect2*vect2';
          sum1  = sum1+...
          (exp(-0.5*xx2))*((2*pi)^(-k/2))*(exp(-0.5*xx))*((2*pi)^(-k/2));
          sum2  = sum2+(exp(-0.5*xx))*((2*pi)^(-k/2));
          i     = i+1;
       end  
       if(sum2==0)
         sum2 = 1.0e-300;
       end
       summax = (sum1/sum2);
       ymax = a;          
       l    = 1;
       while l<=256;
          y1   = a+l*step;
          sum1 = 0;
          sum2 = 0;
          i    = 1;
          while i <= n0;
             vect1 = (z(n)-x0(i))/hop;
             vect2 = (y1-y(i))/hop;                
             xx    = vect1*vect1';
             xx2   = vect2*vect2';
             sum1  = sum1+...
             (exp(-0.5*xx))*((2*pi)^(-k/2))*(exp(-0.5*xx2))*((2*pi)^(-k/2));
             sum2  = sum2+(exp(-0.5*xx))*((2*pi)^(-k/2));
             i     = i+1;
          end  
          if(sum2==0)
            sum2 = 1.0e-300;
          end       
          sumy = (sum1/sum2);
          if(sumy > summax);
            summax = sumy;
            ymax   = y1;
          end
          l = l+1;
       end 
       ztmode(n,m) = ymax;
       dif(n,m)    = data1(n+m,1)-ztmode(n,m);         
       m           = m+1;
   end     
   n = n+1;
end       
dif_mode   = dif(n2:n3,1:mx);   % Resize matrix
MSFE_mode  = sum(dif_mode*dif_mode')/mx;        
RMAFE_mode = (100/mx)*sum(abs(dif_mode)'./abs(data1(n2+1:nr,1)));
